. ./utils.ps1
. ./globals.ps1

if ( -not(isInSolutionStore($wsp)) )
{
	writeMessage("$wsp is not in the solution store")
	return
}

if (isSolutionDeployed($wsp))
{
	writeMessage("Uninstalling $wsp")
	& uninstall-spsolution -identity $wsp -webapplication $webapp -confirm:$false
	writeMessage("Waiting for $wsp to uninstall ")
	while (isSolutionDeployed($wsp)) {
		write-host "." -nonewline; 
		start-sleep -s 1
	}
	# wait a little more to be sure
	start-sleep -s 1
	writeMessage("Complete!")
}

writeMessage("Removing $wsp from solution store")
& remove-spsolution -identity $wsp -confirm:$false
