function isInSolutionStore([string] $name)
{
	if ( (&get-spsolution | where {$_.name -eq $name}) -eq $null)
	{
		return $false;
	}
	return $true;
}

function isSolutionDeployed([string] $name)
{
	if (  (&get-spsolution -identity $name | where {$_.deployed -eq [bool]1} ) -ne $null ) {
		return $true;
	}
	else {
		return $false;
	}
}

function writeMessage([string] $message)
{
	write-host $message -foregroundcolor white  -background darkblue
}
