﻿using System;
using System.Web.UI;
using Microsoft.SharePoint.WebPartPages;

namespace SoftArtisans.Tutorial.AjaxWebPart
{
    public class SampleWebPart : Microsoft.SharePoint.WebPartPages.WebPart
    {
        #region Fields

        private SampleUserControl _uc = null;

        #endregion

        protected override void OnInit(EventArgs e)
        {
            base.OnInit(e);

            // Add required ScriptManager control if none exists (only 1 allowed on page)
            if (ScriptManager.GetCurrent(this.Page) == null)
            {
                ScriptManager scriptManager = new ScriptManager();
                scriptManager.ID = "scriptManager";
                scriptManager.EnablePartialRendering = true;

                this.Page.Form.Controls.AddAt(0, scriptManager);
            }

            _uc = (SampleUserControl)this.Page.LoadControl("~/_CONTROLTEMPLATES/SoftArtisans.Tutorial.AjaxWebPart/SampleUserControl.ascx");
        }

        protected override void CreateChildControls()
        {
            base.CreateChildControls();

            this.Controls.Add(_uc);
        }

    }   // class
}   // namespace